// ------------------------------------
//       STDIO CONSOLE INTERFACE
//            Version 1.01
//      by: Harry Konstas 00/12/28
// ------------------------------------


#include "OBL.h"
#include "FfsLib.h"

typedef void *va_list;
#define va_start(ap, parmN) ((void)((ap) = (va_list)((char *)(&parmN)+((sizeof(parmN)+1) & 0xfffe))))

#define gets(s) GetStdin(pOut,s)
#define getch GetStdKey
#define putch(c) PutStdout(pOut,c)

#define strlen StrLen
#define strstr StrStr
#define strcmp StrCompare
#define strcpy StrCopy
#define strcat StrCat
#define sprintf StrPrintF
#define malloc MemPtrNew
#define free MemPtrFree
#define fabs AbsFloat
#define atof AtoFloat
#define ftoa FloatToA
#define atol StrAToI

int main(int argc, char *argv[]);

UInt FfsRef,cfcard=0; 
STDOUT *pOut;
char curpath[100];

// ------------------------------------ 
//             Utilities
// ------------------------------------

void printf(char *fs)
{
  char buf[100];

  va_list parm;

  va_start(parm,fs);
  StrVPrintF(buf,fs,parm);
  PrintStdout(pOut,buf);

}
void printf(char *fs, ...);

void beep(void)
{
  SndPlaySystemSound(1);
}

int UserAbort(void)
{
  int x,y,t;

  EvtGetPen(&x,&y,&t);
  if((t)&&y>160&&x<30) return 1;
 
  return 0;
}

void clrscr(void)
{
  ClearStdout(pOut);
}

void gotoxy(int x, int y)
{
  pOut->curcol=x;
  pOut->currow=y;
}

char *strupr(char *s)
{
  int i=0;

  while(s[i]) if(s[i++]>96) s[i-1]-=32;
  return s;
}

char *getdate(char *buffer)
{

  DateTimePtr pD;

  pD=MemPtrNew(sizeof(DateTimeType));

  TimSecondsToDateTime(TimGetSeconds(),pD);
  StrPrintF(buffer,"%02d/%02d/%02d",
          pD->month, pD->day, pD->year);

  MemPtrFree(pD);
  return buffer;

}

char *RevStr(char *s)
{

  int i,d=0;
  char buffer[100];

  i=StrLen(s)-1; if(i>99) return 0;
  while(i!=-1) buffer[d++]=s[i--];
  buffer[d]=0;
  StrCopy(s,buffer);
  return buffer;

}

char *LongToA(long value, char *string)
{
    char *ptr;
    int flag = 0;

    if (value < 0) {
       if (value == -2147483648) 
         return StrCopy(string, "-2147483648");
       flag = '-';
       value = -value;
    }

    ptr = string;

    do {
      *(ptr++) = (char) (value  % 10 + 48);
    } while ((value /= 10) != 0);

    *ptr++ = (char) flag;
    *ptr = 0;
    return RevStr(string);

}

float atof(char *s)
{

  FlpCompDouble cf;
  float f;

  cf.fd=FlpAToF(s);
  f=cf.d;

  return f;

}

char *ftoa(float f, char *buf)
{

  float f2;
  long v;
  char rbuf[20];

  if(f==0) {
    StrCopy(buf,"0.00");
    return buf;
  }

  v=(long)f;
  LongToA(v,buf);

  f2=(float)v;
  f2=(f-f2)*100;
  if(f2<0) f2=f2*-1;
  v=(long)f2;

  f2=f2-(float)v;
  if(f2>0.40) v++;

  LongToA(v,rbuf);
  StrCat(buf,".");
  if(v<10) StrCat(buf,"0");
  StrCat(buf,rbuf);

  return buf;

}

float abs(float x)
{
  if(x<0) x=x*-1;
  return x;
}

char *itoa(int v,char *buffer,int base)
{
  StrPrintF(buffer,"%d",v);
  return buffer;
}

int atoi(char *buffer)
{
  int v;

  v=(int)StrAToI(buffer);
  return v;
}

char *ltoa(long v,char *buffer,int base)
{
  LongToA(v,buffer);
  return buffer;
}

int findfirst(char *mask, ffblk *stat, int flags)
{
  return FfsFindfirst(FfsRef,mask,flags,stat);
}

int findnext(ffblk *stat)
{
  return FfsFindnext(FfsRef,stat);
}

int chdir(char *path)
{
  return FfsChdir(FfsRef,path);
}

char *getcwd(char *buf, int buflen)
{
  FfsGetcwd(FfsRef,buf,buflen); 
  return buf;
}

int open(char *fname, int flags, int mode)
{
  return FfsOpen(FfsRef,fname,flags,mode);
}

int close(int h)
{
  int r;

  r=FfsClose(FfsRef,h);

  return r;
}

int read(int h,void *buf,int size)
{
  return FfsRead(FfsRef,h,buf,size); 
}

int write(int h,void *buf,int size)
{
  return FfsWrite(FfsRef,h,buf,size); 
}

long lseek(int h,long offset,int origin)
{
  return FfsLseek(FfsRef,h,offset,origin); 
}

int remove(char *fname)
{
  return FfsRemove(FfsRef,fname); 
}

int rename(char *oldname,char *newname)
{
  return FfsRename(FfsRef,oldname,newname); 
}

void getdfree(unsigned char drive, diskfree_t *dtable)
{
  FfsGetdiskfree(FfsRef,drive,dtable);
}

int mkdir(char *dirname)
{
  return FfsMkdir(FfsRef,dirname);
}

int rmdir(char *dirname)
{
  return FfsRmdir(FfsRef,dirname);
}

Handle GetTinyFont(int fID)
{

  Handle resH;
  FontPtr pData;

  resH=DmGetResource('tFNT',1000);
  if(resH==NULL) return NULL;

  pData=MemHandleLock(resH);

  if(FntDefineFont(fID,pData)!=0) 
    return NULL;
 
  return resH;

}

void DiscardTinyFont(Handle resH)
{

  DmReleaseResource(resH);
  MemHandleUnlock(resH);

}

void DeleteDB(char *name)
{

  LocalID id;
  DmOpenRef db;

  id=DmFindDatabase(0,name);
  if(id) DmDeleteDatabase(0,id);

}

DmOpenRef NewDB(char *fname,ULong creator,ULong type)
{

  int err;
  DmOpenRef db;
  LocalID id;
  UInt attr;

  DeleteDB(fname);

  err= DmCreateDatabase(0,fname,creator,type,false);

  if(err==0) {
    id = DmFindDatabase(0,fname);

    DmDatabaseInfo(0,id,NULL,&attr,NULL,NULL,
      NULL,NULL,NULL,NULL,NULL,NULL,NULL);

    attr=attr|0x008; // set backup bit
    DmSetDatabaseInfo(0,id,NULL,&attr,NULL,NULL,
      NULL,NULL,NULL,NULL,NULL,NULL,NULL);
    
    db = DmOpenDatabase(0,id,dmModeReadWrite);

    return db;
  }

  return NULL;

}

DmOpenRef OpenDB(char *fname)
{

  int err;
  DmOpenRef db;
  LocalID id;

  id=DmFindDatabase(0,fname);
  if(id) db = DmOpenDatabase(0,id,dmModeReadWrite);
  else return NULL;

  return db;

}

int AppSwitch(char *fname)
{

  LocalID dbID;

  dbID=DmFindDatabase(0,fname);
  if(dbID==NULL) return 0;

  SysUIAppSwitch(0,dbID,sysAppLaunchCmdNormalLaunch,NULL);
  return 1;
}

// ------------------------------------ 
//      Launch DOS app with params
// ------------------------------------

void LaunchDOS(void)
{
 
  int i,size,n,r;
  int NumArgs=0, flag=0;
  char *data, *CmdArgs[16];

  VoidHand h;
  DmOpenRef db;

  strcpy(curpath,"\\");
  db = OpenDB("TRGDOSdata");

  if(db) {
    n=DmNumRecords(db);
    if(n>15) n=15;

    for(i=0;i<n;i++) {
      h=DmQueryRecord(db,i);
      if(!h) break;
      size=MemHandleSize(h);
      if(!size) break;
      data=MemHandleLock(h);

      if(i==0) strcpy(curpath,data);
      else{
        CmdArgs[NumArgs]=malloc(40);
        strcpy(CmdArgs[NumArgs],data);
        NumArgs++; flag=1;
      }

      MemHandleUnlock(h);
    }
  }

  if(db) DmCloseDatabase(db);

  if(flag) NumArgs-=1;
  else NumArgs=-1;

  main(NumArgs,CmdArgs);

  if(flag)
    for(i=0;i<NumArgs;i++) 
      free(CmdArgs[i]);

}

// ------------------------------------ 
//              M A I N
// ------------------------------------


DWord PilotMain( Word cmd, Ptr cmdPBP, Word launchFlags) 
{

  int err=0,fID;
  Handle fntH;
  char buf[40];
  FormPtr frmP;

  switch (cmd)
  {
    case sysAppLaunchCmdNormalLaunch:

      frmP = FrmInitForm(1000);
      FrmSetActiveForm(frmP);

      fntH = GetTinyFont(128);
      if(fntH) fID  = FntSetFont(128);
      pOut=OpenStdout(0,0,159,155);

      // Open Ffs library
      if(SysLibLoad('libr','FfsL',&FfsRef)==0) {
        FfsLibOpen(FfsRef);
        if(FfsCardIsInserted(FfsRef,0)) 
          err=0; else err=1;
      }
      else err=2;

      if(!err) cfcard=1;

      LaunchDOS();

      if(cfcard) {
        // Close Ffs library
        FfsLibClose(FfsRef);
        SysLibRemove(FfsRef); 
      }

      CloseStdout(pOut);
      FntSetFont(fID);
      DiscardTinyFont(fntH);

	 break;

    default:
	 break;
  }
  return 0;
}
 
 
